import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(14, 4))

# Define colors
status_colors = {
    'parked': 'red',
    'double_parked_clear': 'yellow',
    'clear': 'green'
}

# Define curbs and cars
curbs = [
    {'id': 'curb_0', 'cars': [('car6', 'parked'), ('car7', 'double_parked_clear')]},
    {'id': 'curb_1', 'cars': [('car1', 'parked'), ('car8', 'double_parked_clear')]},
    {'id': 'curb_2', 'cars': [('car9', 'parked'), ('car4', 'double_parked_clear')]},
    {'id': 'curb_3', 'cars': [('car3', 'clear')]},
    {'id': 'curb_4', 'cars': [('car0', 'clear')]},
    {'id': 'curb_5', 'cars': [('car5', 'clear')]},
    {'id': 'curb_6', 'cars': [('car2', 'clear')]}
]

# Draw curbs and cars
for i, curb in enumerate(curbs):
    # Draw curb
    ax.add_patch(patches.Rectangle((i*2, 0), 1.5, 0.6, edgecolor='black', facecolor='none'))
    ax.text(i*2 + 0.75, 0.7, curb['id'], ha='center', va='bottom', fontsize=9, color='black')

    # Draw cars
    for j, (car, status) in enumerate(curb['cars']):
        car_x = i*2 + 0.5 + (j * 0.3)
        car_y = 0.3
        ax.add_patch(patches.Circle((car_x, car_y), 0.12, color=status_colors[status]))
        ax.text(car_x, car_y - 0.18, f"{car}\n{status}", ha='center', va='top', fontsize=7, color='black')

# Create legend
legend_elements = [
    patches.Patch(facecolor='red', edgecolor='black', label='Parked'),
    patches.Patch(facecolor='yellow', edgecolor='black', label='Double Parked Clear'),
    patches.Patch(facecolor='green', edgecolor='black', label='Clear')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1))

# Set limits and hide axes
ax.set_xlim(-0.5, 14)
ax.set_ylim(-0.5, 1)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_40.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Text labels and statuses overlap, making them unclear and hard to read.
